import "react-native-gesture-handler";
import React, { useCallback, useEffect, useState } from "react";
import {
    SafeAreaView,
    StyleSheet,
    StatusBar,
    LogBox
} from "react-native";
LogBox.ignoreAllLogs();
LogBox.ignoreLogs([
    'Non-serializable values were found in the navigation state',
]);

import { NavigationContainer } from "@react-navigation/native";
import {
    DMSans_500Medium,
    DMSans_700Bold,
    DMSans_400Regular,
} from "@expo-google-fonts/dm-sans";
import {
    Roboto_400Regular,
    Roboto_500Medium,
    Roboto_500Medium_Italic,
} from "@expo-google-fonts/roboto";
import { useFonts } from "expo-font";
import "./src/language/i18n";
import { GestureHandlerRootView } from "react-native-gesture-handler";
import Root from "./components/Navigation/Root";
import * as SplashScreenControl from 'expo-splash-screen';
import * as Linking from 'expo-linking';
const prefix = Linking.createURL('');
import { PRODUCT_DETAILS } from "./components/Navigation/RouteNames";
import appTheme from "./theme/theme";
import SplashScreen from "./src/components/SplashScreen/SplashScreen";
import useCustomToast from "./hooks/useCustomToast";
import dpr from "./screens/Utilities/CustomStyleAttribute/dpr";
SplashScreenControl.preventAutoHideAsync();

export default function App() {
    const [appIsReady, setAppIsReady] = useState(false);
    const showToast = useCustomToast();
    let [fontsLoad] = useFonts({
        DMSans_400Regular,
        DMSans_500Medium,
        DMSans_700Bold,
        Roboto_400Regular,
        Roboto_500Medium,
        Roboto_500Medium_Italic,
    });

    const config = {
        screens: {
          login: 'login',
          productDetails: `${PRODUCT_DETAILS}/:slug`
        },
      };

    const linking = {
        prefixes: [prefix],
        config
    };


    useEffect(() => {
        async function prepare() {
            try {
              await fontsLoad;
            } catch (e) {
              console.warn(e);
            } finally {
              setAppIsReady(true);
            }
          }
      
          prepare();
      }, []);

      const delay = (fun, timeout) =>
        new Promise((resolve) => setTimeout(resolve, timeout))
          .then(fun)
          .catch((e) =>  showToast({
            text1: trans(e?.message),
            type: 'common',
            position: 'bottom',
            props: { variant: 'error' }
        }));
    
      const onLayoutRootView = useCallback(async () => {
        if (appIsReady) {
            await delay(
              () =>
                StatusBar.pushStackEntry({
                  barStyle: 'dark-content',
                  animated: true,
                  backgroundColor: 'transparent',
                }),
              2000 // 2 sec delay for loading and render data
            );
            delay(SplashScreenControl.hideAsync, 100); // hide SplashScreen one frame after StatusBar gets translucent
          }
      }, [appIsReady]);
    
      if (!appIsReady) {
        return null;
      }
    
    return (
        <>
            <GestureHandlerRootView style={styles.viewFlex}>
                <SafeAreaView style={styles.appContainer}>
                    <NavigationContainer
                        onReady={onLayoutRootView}
                        theme={appTheme}
                        linking={linking}
                        fallback={<SplashScreen/>}
                    >
                        <Root/>
                    </NavigationContainer>
                </SafeAreaView>
            </GestureHandlerRootView>
        </>
    );
}

const styles = StyleSheet.create({
    appContainer: {
        flex: 1,
    },
    viewFlex: {
        flex: 1,
    }
});
